/* -*- c++ -*- */
/* 
 * Copyright 2013 <+YOU OR YOUR COMPANY+>.
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */


#ifndef INCLUDED_JUHA_CHIRP_DOWNCONVERT_H
#define INCLUDED_JUHA_CHIRP_DOWNCONVERT_H

#include <juha/api.h>
#include <gnuradio/sync_block.h>

namespace gr {
  namespace juha {

    /*!
     * \brief <+description of block+>
     * \ingroup juha
     *
     */
    class JUHA_API chirp_downconvert : virtual public gr::sync_block
    {
     public:
      typedef boost::shared_ptr<chirp_downconvert> sptr;

      /*!
       * \brief Return a shared_ptr to a new instance of juha::chirp_downconvert.
       *
       * To avoid accidental use of raw pointers, juha::chirp_downconvert's
       * constructor is in a private implementation
       * class. juha::chirp_downconvert::make is the public interface for
       * creating new instances.
       */
      static sptr make();

      virtual void set_timing(double t, double dur) = 0;

      // f0 and change rate
      virtual void set_chirp_par(double f0, double rate) = 0;
      virtual void set_f0(double f) = 0;

      virtual void set_samp_rate(double r) = 0;
      
      // file name to output chirp
      virtual void set_fname(char *fname) = 0;
      
      // set decimation rate
      virtual void set_dec(int dec) = 0;
      // set decimation rate
      virtual int is_done() = 0;
      virtual double get_lag() = 0;
    };

  } // namespace juha
} // namespace gr

#endif /* INCLUDED_JUHA_CHIRP_DOWNCONVERT_H */

